(******************************************************************************)
(*                                                             	              *)
(* Beispielprogramm zur Benutzung der Image Mastering API                     *)
(* Autor : Bernd Ua Mail : Bernd.Ua@uaconsulting.de                           *)
(* Datum : 02.09.2004                                                         *)
(* Source : http://www.uaconsulting.de/de/downloads/downloads.htm             *)
(* Web : http://www.uaconsulting.de                                           *)
(*                                                                            *)
(* Das Beispiel verwendet die WinAPI Portierung des Project Jedi              *)
(* um das Beispiel compilieren zu knnen, sind diese Quellen erforderlich     *)
(*                                                                            *)
(* die aktuellen Versionen der WinApi bersetzung finden sich unter 					*)
(* http://delphi-jedi.org                                                     *)
(* oder auf der Seite des Entwicklers Marcel van Brakel                       *)
(* http://members.chello.nl/m.vanbrakel2                                      *)
(*                                                             	              *)
(* Die WinAPI-Library steht unter Mozilla Public License Version 1.1          *)
(* http://www.mozilla.org/MPL/MPL-1.1.html                                    *)
(*                                                             	              *)
(* Verwendung dieses Beispiels erfolgt auf eigene Gefahr, der Autor bernimmt *)
(* keine Garantie fr die Funktionsfhigkeit dises Programms   	              *)
(*                                                             	              *)
(******************************************************************************)


unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls,
  jwaImapi,jwaImapiError,  // wenn diese Dateien fehlen WinApi.zip von og Quellen herunterladen
  AxCtrls,FileCtrl;

type
  TFrmMain = class(TForm)
    PageControl1: TPageControl;
    tsRecorderInfo: TTabSheet;
    tsBurn: TTabSheet;
    lbFormats: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    lbRecorders: TListBox;
    btnShowInfo: TButton;
    btnSelectRecorder: TButton;
    lbProps: TListBox;
    Button1: TButton;
    prbData: TProgressBar;
    Label3: TLabel;
    Label4: TLabel;
    prbBurn: TProgressBar;
    memMessages: TMemo;
    Label5: TLabel;
    cbMultiSession: TCheckBox;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnShowInfoClick(Sender: TObject);
    procedure btnSelectRecorderClick(Sender: TObject);
    procedure lbRecordersClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    FCookie : Cardinal;
    FHelper : IDiscMasterProgressEvents;
    FDiscMaster : IDiscMaster;
    FRecorders : TInterfaceList;
    function GetDiscMaster: IDiscMaster;
    procedure ListFormats(aList: TStrings);
    procedure ListRecorders(aIntfList: TInterfaceList; aDisplay: TStrings);
    function GetFirstRecorder( out aRecorder: IDiscRecorder) : Boolean ;
  public
    property DiscMaster : IDiscMaster read GetDiscMaster;
  end;

  TCallBackObj = class(TInterfacedObject,IDiscMasterProgressEvents)
  private
    FOwner : TFrmMain;
  public
    constructor Create (aOwner: TFrmMain);
    function NotifyAddProgress(nCompletedSteps: Integer;
      nTotalSteps: Integer): HRESULT; stdcall;
    function NotifyBurnComplete(status: HRESULT): HRESULT; stdcall;
    function NotifyBlockProgress(nCompleted: Integer;
      nTotal: Integer): HRESULT; stdcall;
    function NotifyClosingDisc(nEstimatedSeconds: Integer): HRESULT;
      stdcall;
    function NotifyEraseComplete(status: HRESULT): HRESULT; stdcall;
    function NotifyPnPActivity: HRESULT; stdcall;
    function NotifyPreparingBurn(nEstimatedSeconds: Integer): HRESULT;
      stdcall;
    function NotifyTrackProgress(nCurrentTrack: Integer;
      nTotalTracks: Integer): HRESULT; stdcall;
    function QueryCancel(out pbCancel: LongBool): HRESULT; stdcall;
  end;

var
  FrmMain: TFrmMain;

implementation

{$R *.dfm}

uses
  ComObj,ActiveX, Math, AboutForm;

function AddDirToStorage (aStorage : IStorage; aPath: String): Boolean;
var
  sPath: String;
  sr : SysUtils.TSearchRec;
  swStreamName,swFolderName : WideString;
  stgStream : IStream;
  stgSubDir : IStorage;
  aFilestream : TFileStream;
  aOleStream  : TOleStream;
begin
  Result := true;
  aFilestream := nil;
  aOleStream :=nil;
  sPath := IncludeTrailingPathDelimiter(aPath);
  if SysUtils.FindFirst(sPath + '*.*', faAnyFile, sr) = 0 then
    try
      repeat
        if (sr.Name <> '.') and (sr.Name <> '..') then
          if (sr.Attr and faDirectory <= 0) then
            try
              try
                // Datei-Inhalt einlesen und im Stream ablegen
                aFileStream := TFileStream.Create(sPath + sr.Name,fmOpenRead);
                aFileStream.Position := 0;
                // Stream-Eintrag im Storage fr die zu sichernde Datei anlegen
                swStreamName := sr.Name;
                OleCheck(aStorage.CreateStream(PWideChar(swStreamName),
                           STGM_CREATE or STGM_READWRITE or STGM_DIRECT or
                           STGM_SHARE_EXCLUSIVE, 0, 0, stgStream));
                // Verbindung zum IStream-Interface ber OLE-Stream
                aOleStream := TOleStream.Create(stgStream);
                aOleStream.CopyFrom(aFileStream, aFileStream.Size);
              finally
                FreeAndNil(aOleStream);
                FreeAndNil(aFileStream);
              end;
            except
               Result :=false;
            end
          else
            begin
              swFolderName := sr.Name;
              OleCheck(aStorage.CreateStorage(PWideChar(swFoldername),
                 STGM_READWRITE or STGM_CREATE or STGM_DIRECT or
                 STGM_SHARE_EXCLUSIVE , 0, 0, stgSubDir));
              AddDirToStorage(stgSubDir,sPath + sr.Name+ '\');
            end;
        Application.ProcessMessages;
    until FindNext(sr) <> 0;
  finally
    SysUtils.FindClose(sr);
  end;
end;



procedure TFrmMain.ListFormats(aList: TStrings);
var
  lEnumFormats : IEnumDiscMasterFormats;
  lFormatID : TGuid;
  pfetched : Cardinal;
begin
  aList.Clear;
  OleCheck(DiscMaster.EnumDiscMasterFormats(lEnumFormats));
  pFetched := 1;
  lEnumFormats.Next(1,lFormatID,pFetched);
  while pFetched > 0 do
    begin
      if IsEqualGUID(lFormatID,IID_IRedbookDiscMaster) then
        aList.Add('Redbook Audio CD');
      if IsEqualGUID(lFormatID,IID_IJolietDiscMaster) then
        aList.Add('Joilet Daten CD');
      lEnumFormats.Next(1,lFormatID,pFetched);
    end;
end;



procedure TFrmMain.ListRecorders(aIntfList: TInterfaceList; aDisplay: TStrings);
var
  lEnumRecorders : IEnumDiscRecorders;
  lRecIntf : IDiscRecorder;
  pfetched : Cardinal;
  pPath,pVendorStr,pProductId,pRevision : PWideChar;
begin
  aIntfList.Clear;
  aDisplay.Clear;
  OleCheck(DiscMaster.EnumDiscRecorders(lEnumRecorders));
  pFetched := 1;
  lEnumRecorders.Next(1,lRecIntf,pFetched);
  while pFetched > 0 do
    begin
      aIntfList.Add(lRecIntf);
      OleCheck(lRecIntf.GetDisplayNames(pVendorStr,pProductId,pRevision));
      OleCheck(lRecIntf.GetPath(pPath));
      aDisplay.Add(WideCharToString(pPath) + ' ' +
                            WideCharToString(pVendorStr) + ' ' +
                            WideCharToString(pProductId) + ' ' +
                            WideCharToString(pRevision));
      lEnumRecorders.Next(1,lRecIntf,pFetched);
    end;
end;


function TFrmMain.GetFirstRecorder( out aRecorder: IDiscRecorder) : Boolean ;
var
  lEnumRecorders : IEnumDiscRecorders;
  pfetched : Cardinal;
begin
  aRecorder := nil;
  OleCheck(DiscMaster.EnumDiscRecorders(lEnumRecorders));
  pFetched := 0;
  lEnumRecorders.Next(1,aRecorder,pFetched);
  Result := pFetched > 0;
end;


procedure TFrmMain.FormCreate(Sender: TObject);
begin
  // Create Main Object
  FDiscMaster := CreateComObject(MSDiscMasterObj) as IDiscMaster;
  // Open Imapi
  if FDiscMaster.Open = IMAPI_E_ALREADYOPEN then
    ShowMessage('Imapi Schnittstelle ist bereits geffnet');

  FRecorders := TInterfaceList.Create;
  FHelper := TCallBackObj.Create(self);
  FDiscMaster.ProgressAdvise(FHelper,FCookie);
end;


procedure TFrmMain.FormDestroy(Sender: TObject);
begin
  if Assigned(FDiscMaster) then
    begin
      FDiscMaster.ProgressUnadvise(FCookie);
      FDiscMaster.Close;
      FDiscMaster := nil;
    end;
  FHelper := nil;
end;


function TFrmMain.GetDiscMaster: IDiscMaster;
begin
  if Assigned(FDiscMaster) then
    Result := FDiscMaster
  else
    raise Exception.Create('Imapi-Objekt nicht vorhanden');
end;


procedure TFrmMain.btnShowInfoClick(Sender: TObject);
var
  iUnk : IUnknown;
begin
  ListFormats(lbFormats.Items);
  OleCheck(DiscMaster.SetActiveDiscMasterFormat(IID_IJolietDiscMaster,iunk));
  ListRecorders(FRecorders,lbRecorders.Items);
end;


procedure TFrmMain.btnSelectRecorderClick(Sender: TObject);
var
  res : HResult;
begin
  if lbRecorders.ItemIndex < 0 then
    raise Exception.Create('Kein Recorder in Liste gewhlt');
  res := DiscMaster.SetActiveDiscRecorder(FRecorders.Items[lbRecorders.ItemIndex] as IDiscRecorder);
  case res of
    IMAPI_E_DEVICE_NOTPRESENT : raise Exception.Create('Gert wurde aus dem System entfernt');
    IMAPI_E_DISCFULL          : ShowMessage('CD ist voll, Readonly oder Audioformat');
    IMAPI_E_MEDIUM_NOTPRESENT : ShowMessage('Kein medium eingelegt');
    IMAPI_E_NOTOPENED         : raise Exception.Create('Imapi wurde nicht initialisiert');
    IMAPI_E_NOACTIVEFORMAT    : raise Exception.Create('Kein Format ausgewhlt');
    IMAPI_E_STASHINUSE        : raise Exception.Create('Ein anderer Recorder wurde bereits ausgewhlt');
  end;
end;


procedure TFrmMain.lbRecordersClick(Sender: TObject);
var
  FRecorder : IDiscRecorder;
  iProps : IPropertyStorage;
  recType : Integer;
  recState : Cardinal;
  medType  : Integer;
  medFlags : Integer;
  iPropSpec : PropSpec;
  pValue : TPropVariant;
begin
  lbProps.Clear;
  FRecorder := FRecorders.Items[lbRecorders.ItemIndex] as IDiscRecorder;

  if Succeeded(FRecorder.GetRecorderType(recType)) then
    case recType of
      RECORDER_CDR  : lbProps.Items.Add('Recordertyp : CDR');
      RECORDER_CDRW : lbProps.Items.Add('Recordertyp : CDRW');
    end;

  if Succeeded(FRecorder.GetRecorderState(recState)) then
    case recState of
      RECORDER_DOING_NOTHING : lbProps.Items.Add('Status : Idle');
      RECORDER_OPENED        : lbProps.Items.Add('Status : geffnet');
      RECORDER_BURNING       : lbProps.Items.Add('Status : Brennvorgang');
    end;

  if Succeeded(FRecorder.QueryMediaType(medType,medFlags)) then
    begin
      case medtype of
      MEDIA_CDDA_CDROM : lbProps.Items.Add('CDDA-CDROM');
      MEDIA_CD_ROM_XA  : lbProps.Items.Add('CD-ROM XA');
      MEDIA_CD_I       : lbProps.Items.Add('CD-I');
      MEDIA_CD_EXTRA   : lbProps.Items.Add('CD-EXTRA');
      MEDIA_CD_OTHER   : lbProps.Items.Add('unbekanntes Format');
      MEDIA_SPECIAL    : lbProps.Items.Add('spezielles Format');
      end;
    end;

  FRecorder.GetRecorderProperties(iProps);
  iPropSpec.ulKind := PRSPEC_LPWSTR;
  iPropSpec.lpwstr := 'WriteSpeed';

  OleCheck(iPropS.ReadMultiple(1, @iPropSpec, @pValue));
  if pValue.vt = VT_I4 then
    lbProps.Items.Add('WriteSpeed : ' + IntToStr(pValue.lVal));

end;


procedure TFrmMain.Button1Click(Sender: TObject);
var
  iunk         : IUnknown;
  aJDMaster    : IJolietDiscMaster;
  aRecorder    : IDiscRecorder;
  aRootStorage : IStorage;
  hr           : Hresult;
  sDir         : String;
begin
  if not SelectDirectory(sDir,[],0) then
    Exit;
  // Storage aufbauen
  OleCheck(StgCreateDocFile(nil,
                            STGM_CREATE or STGM_READWRITE or
                            STGM_DIRECT or STGM_SHARE_EXCLUSIVE or STGM_DELETEONRELEASE,
                            0, aRootStorage));
  AddDirToStorage(aRootStorage,sDir);

  DiscMaster.SetActiveDiscMasterFormat(IID_IJolietDiscMaster,iunk);
  aJDMaster := iunk as IJolietDiscMaster;
  if not Succeeded(DiscMaster.GetActiveDiscRecorder(aRecorder)) then
    if GetFirstRecorder(aRecorder) then
      begin
        hr := DiscMaster.SetActiveDiscRecorder(aRecorder);
        case hr of
          IMAPI_E_DEVICE_NOTPRESENT     : raise Exception.Create('Gert wurde aus dem System entfernt');
          IMAPI_E_DISCFULL              : ShowMessage('CD ist voll, Readonly oder Audioformat');
          IMAPI_E_MEDIUM_NOTPRESENT     : ShowMessage('Kein Medium eingelegt');
          IMAPI_E_NOTOPENED             : raise Exception.Create('Imapi wurde nicht initialisiert');
          IMAPI_E_NOACTIVEFORMAT        : raise Exception.Create('Kein Format ausgewhlt');
          IMAPI_E_STASHINUSE            : raise Exception.Create('Ein anderer Recorder wurde bereits ausgewhlt');
        end;
      end
    else
      begin
        ShowMessage('Kein Recorder gefunden');
        Exit;
      end;

  if not cbMultiSession.Checked then
    DiscMaster.ClearFormatContent;

  hr := aJDMaster.AddData(aRootStorage,1);
  case hr of
    S_OK                   : ;
    IMAPI_E_NOTOPENED      : raise Exception.Create('IMAPI nicht geffnet');
    IMAPI_E_FILEEXISTS     : raise Exception.Create('Datei existiert bereits');
    IMAPI_E_DISCFULL       : raise Exception.Create('CD ist voll');
    IMAPI_E_BADJOLIETNAME  : raise ExCeption.Create('Ungltiger name');
  else
    OleCheck(hr);  // zum Beispiel Fehler wg Storage
  end;

  hr := DiscMaster.RecordDisc(false,true) ;
  case hr of
    S_OK                          : ; // nix tun
    IMAPI_E_NOTOPENED             : raise Exception.Create('IMAPI nicht gefnet');
    IMAPI_E_WRONGDISC             : raise Exception.Create('IMAPI WRONGDISC');
    IMAPI_E_NOACTIVEFORMAT        : raise Exception.Create('IMAPI NOACTIVEFORMAT');
    IMAPI_E_NOACTIVERECORDER      : raise Exception.Create('IMAPI NOACTIVERECORDER');
    IMAPI_E_USERABORT             : raise Exception.Create('IMAPI USERABORT');
    IMAPI_E_GENERIC               : raise Exception.Create('IMAPIGENERIC ');
    IMAPI_E_MEDIUM_NOTPRESENT     : raise Exception.Create('IMAPI MEDIUM_NOTPRESENT');
    IMAPI_E_DEVICE_NOTACCESSIBLE  : raise Exception.Create('IMAPIDEVICE_NOTACCESSIBLE ');
    IMAPI_E_INITIALIZE_WRITE      : raise Exception.Create('IMAPI_E_INITIALIZE_WRITE ');
    IMAPI_E_INITIALIZE_ENDWRITE   : raise Exception.Create('IMAPI_E_INITIALIZE_ENDWRITE ');
    IMAPI_E_FILESYSTEM            : raise Exception.Create('IMAPI_E_FILESYSTEM ');
    IMAPI_E_DISCINFO              : raise Exception.Create('IMAPI_E_DISCINFO ');
    IMAPI_E_TRACKOPEN             : raise Exception.Create('IMAPI_E_TRACKOPEN ');
    IMAPI_E_INVALIDIMAGE          : raise Exception.Create('IMAPI_E_INVALIDIMAGE ');
    IMAPI_E_LOSS_OF_STREAMING     : raise Exception.Create('IMAPI_E_LOSS_OF_STREAMING ');
    IMAPI_E_COMPRESSEDSTASH       : raise Exception.Create('IMAPI_E_COMPRESSEDSTASH ');
    IMAPI_E_ENCRYPTEDSTASH        : raise Exception.Create('IMAPI_E_ENCRYPTEDSTASH ');
    IMAPI_E_NOTENOUGHDISKFORSTASH : raise Exception.Create('IMAPI_E_NOTENOUGHDISKFORSTASH ');
    IMAPI_E_REMOVABLESTASH        : raise Exception.Create('IMAPI REMOVABLESTASH');
  else
    OleCheck(hr)
  end;

end;


{ TCallBackObj }

constructor TCallBackObj.Create(aOwner: TFrmMain);
begin
  inherited Create;
  FOwner := aOwner;
end;


function TCallBackObj.NotifyAddProgress(nCompletedSteps,
  nTotalSteps: Integer): HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.prbData.Max := nTotalSteps;
      FOwner.prbData.Position := nCompletedSteps;
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyBlockProgress(nCompleted,
  nTotal: Integer): HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.prbBurn.Max := nTotal;
      FOwner.prbBurn.Position := nCompleted;
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyBurnComplete(status: HRESULT): HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.memMessages.Lines.Add('Brennen abgeschlossen');
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyClosingDisc(
  nEstimatedSeconds: Integer): HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.memMessages.Lines.Add('CD wird abgeschlossen');
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyEraseComplete(status: HRESULT): HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.memMessages.Lines.Add('Lschen der CD abgeschlossen');
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyPnPActivity: HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.memMessages.Lines.Add('Liste der Recorder gendert');
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyPreparingBurn(nEstimatedSeconds: Integer): HRESULT;
begin
  If Assigned(FOwner) then
    begin
      FOwner.memMessages.Lines.Add(Format('Brennen beginnt in %d sec',[nEstimatedSeconds]));
    end;
  Result := s_OK;
end;


function TCallBackObj.NotifyTrackProgress(nCurrentTrack, nTotalTracks: Integer): HRESULT;
begin
  Result := E_NOTIMPL;
end;


function TCallBackObj.QueryCancel(out pbCancel: LongBool): HRESULT;
begin
  pbCancel := false;
  Result := S_OK;
end;


procedure TFrmMain.Button2Click(Sender: TObject);
begin
  with TFrmAbout.Create(self)do
    try
      ShowModal;
    finally
      Free;
    end;
end;


end.
